//
//  FlightInterfaceController.swift
//  AirAber
//
//  Created by Jan-Peter Krämer on 01/01/16.
//  Copyright © 2016 Mic Pringle. All rights reserved.
//

import WatchKit
import Foundation


class FlightInterfaceController: WKInterfaceController {

	@IBOutlet var flightLabel: WKInterfaceLabel!
	@IBOutlet var routeLabel: WKInterfaceLabel!
	@IBOutlet var boardingLabel: WKInterfaceLabel!
	@IBOutlet var boardTimeLabel: WKInterfaceLabel!
	@IBOutlet var statusLabel: WKInterfaceLabel!
	@IBOutlet var gateLabel: WKInterfaceLabel!
	@IBOutlet var seatLabel: WKInterfaceLabel!
	
	var flight: Flight? {
		didSet {
			if let flight = flight {
				flightLabel.setText("Flight \(flight.shortNumber)")
				routeLabel.setText(flight.route)
				boardingLabel.setText("\(flight.number) Boards")
				boardTimeLabel.setText(flight.boardsAt)
				if flight.onSchedule {
					statusLabel.setText("On Time")
				} else {
					statusLabel.setText("Delayed")
					statusLabel.setTextColor(UIColor.redColor())
				}
				gateLabel.setText("Gate \(flight.gate)")
				seatLabel.setText("Seat \(flight.seat)")
			}
		}
	}
	
    override func awakeWithContext(context: AnyObject?) {
        super.awakeWithContext(context)
		
		if let flight = context as? Flight {
			self.flight = flight
		}
        // Configure interface objects here.
    }

    override func willActivate() {
        // This method is called when watch view controller is about to be visible to user
        super.willActivate()
    }

    override func didDeactivate() {
        // This method is called when watch view controller is no longer visible
        super.didDeactivate()
    }

}
